# scplot <img src="man/figures/logo-135px.png" align="right"/>

<!-- badges: start -->
[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version/scplot?color=blue)](https://CRAN.R-project.org/package=scplot)
[![Downloads](https://cranlogs.r-pkg.org/badges/grand-total/scplot?color=orange)](https://CRAN.R-project.org/package=scplot)
<!-- badges: end -->

*scplot* is an add on package for *scan* which provides a convenient set of functions to create single-case graphics. *scplot* is based on ggplot2.

## How to install *scplot*?

From CRAN:
`install.packages("scplot")`

For the developmental version from GitHub you need the *devtools* package:  
`install.packages("devtools")`  

Then install *scplot* from GitHub with:  
`devtools::install_github("jazznbass/scplot")`

After installation, load the package with:  
`library(scplot)`

You also need to have the *scan* package installed and loaded:   
`install.packages("scan")`  
`library(scan)`

If you get errors, look if a specific package is missing/ not found and try to install the missing package with `install.packages("[name-of-the-missing-package]")`.

## Finding help

- The "home" of *scan* is a good place to start from (https://jazznbass.github.io/scan/)
- For *scplot* look at (https://jazznbass.github.io/scplot/)
- You find in depth information an *scan* in the book [Analyzing single-case data with R and scan](https://jazznbass.github.io/scan-Book/)

## Basic example

```r
library(scan)
library(scplot)
data("exampleABC")
scplot(exampleABC) 
```

